function Hout = LWM_hessFcn(x,l,M1,M2,oprice,K, rf, TTM,weights,objval_scale)
%=====================================================================
% this function returns the Hessian for the fmincon estimation
% effectively, a wrapper function of LWM_Hessian
%=====================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 

[~,~,H]= LWM_MSE(x,M1,M2,oprice,K, rf, TTM,weights,objval_scale);
M  = M1 + M2;
% Hessian of nonlinear equality constraint
% w_1*F_1 + ... + w_{M}*F_{M} - F0 = 0

Hg = sparse(zeros(M*3));
w_range = 1:M;
F_range = M+1:2*M;

Hg(F_range,w_range) = eye(M);
Hg(w_range,F_range) = eye(M);
Hout = real(H + l.eqnonlin(1)*Hg);

end
